## ARP Overview

- **Purpose of ARP:**
    - Maps IP addresses to MAC addresses in a local network.
    - Before sending a datagram, a device checks its ARP cache for the MAC address corresponding to the destination IP.
    - If no entry exists, an ARP request is broadcast.
    - The device with the matching IP responds with its MAC address.
    - The sender updates its ARP table and uses the MAC address for subsequent communications.

---

## ARP Security Vulnerabilities

### Lack of Protection in ARP Protocol

- ARP lacks built-in security.
- Susceptible to various attacks, especially ARP spoofing (ARP cache poisoning) and man-in-the-middle attacks.

---

## ARP Spoofing (ARP Cache Poisoning)

- **Attack Method:**
    - An attacker sends a malicious (often unsolicited) ARP reply (GARP) mapping their MAC address to a legitimate IP.
    - Target devices store the attacker's MAC in their ARP cache.
    - Traffic intended for the legitimate device is sent to the attacker.
- **Consequences:**
    - Enables interception, modification, or blocking of network traffic (man-in-the-middle).
    - Can target hosts, switches, and routers on the same subnet.

---

## Mitigating ARP Spoofing

### Methods

- **Dynamic ARP Inspection (DAI) on Switches**
- **Static ARP Entries** (manual mapping on critical devices)

---

## Dynamic ARP Inspection (DAI)

### How DAI Works

- Intercepts and validates all ARP requests and responses on untrusted switch ports.
- Verifies ARP replies against known MAC-to-IP bindings (from DHCP snooping database or static ARP ACLs).
- Drops ARP packets with invalid bindings.

### Trust Model

- **Trusted Ports:** Forward ARP packets without checks (typically inter-switch links or DHCP server connections).
- **Untrusted Ports:** Intercept and validate all ARP packets (typically access ports to hosts).

### Actions

- Forwards valid ARP packets.
- Drops invalid ARP packets.
- Can rate-limit ARP messages on a port to protect the control plane.
- Ports exceeding rate limits are error-disabled (can be auto-recovered).

---

## Configuration Steps for DAI

1. **Enable DHCP Snooping** (required for DAI to leverage DHCP bindings).
2. **Enable ARP Inspection on VLANs** where protection is needed.
3. **Configure Trusted and Untrusted Interfaces:**
    - Trust inter-switch/trunk links.
    - Leave access ports (to hosts) untrusted.
4. **Set ARP Rate Limits** (e.g., 50 packets/sec on access ports).
5. **Configure ARP ACLs** for statically addressed hosts, if present.
6. **Enable Error Recovery** for error-disabled ports (e.g., after 180 seconds).
7. **Verify Configuration** using show commands.

---

## Verification Commands

- **show ip arp inspection:**  
    Displays general ARP inspection configuration and status.
- **show ip arp inspection interfaces:**  
    Shows trust state and rate limits of each interface.

---

## Example Scenario

- VLAN 100 hosts DHCP-addressed clients; DHCP snooping is configured.
- Statically addressed server connected to Fa0/1 (exception via ARP ACL).
- ARP inspection enabled for VLAN 100.
- User/access ports set as untrusted with ARP rate limiting.
- Interswitch links set as trusted.
- Attacker attempting ARP spoofing is blocked by DAI validation.

---

## Key Takeaways

- ARP is essential but inherently insecure.
- ARP spoofing can redirect, intercept, or disrupt network traffic.
- Dynamic ARP Inspection, combined with DHCP snooping and proper trust configurations, is vital for securing ARP traffic in switched networks.